import { Repository } from 'typeorm';
import { Category } from '../../entities/category.entity';
import { CreateCategoryDto, CategoryResponseDto } from './dto';
export declare class CategoriesService {
    private readonly categoryRepo;
    deactivate(id: number): CategoryResponseDto | PromiseLike<CategoryResponseDto>;
    activate(id: number): CategoryResponseDto | PromiseLike<CategoryResponseDto>;
    constructor(categoryRepo: Repository<Category>);
    private toCategoryResponseDto;
    create(createCategoryDto: CreateCategoryDto): Promise<CategoryResponseDto>;
    findAll(): Promise<CategoryResponseDto[]>;
    findAllWithProducts(): Promise<CategoryResponseDto[]>;
    findOne(id: number): Promise<CategoryResponseDto>;
    update(id: number, updateCategoryDto: CreateCategoryDto): Promise<CategoryResponseDto>;
    remove(id: number): Promise<void>;
    searchByName(name: string): Promise<CategoryResponseDto[]>;
}
